<?php

class ConfigHistory extends ObjectModel
{
	/** @var string Name */
	public $id_ns_caisse_orders;
		
	/** @var integer */
	public $id_order;
	
	public $id_shop;
	
	/** @var integer */
	public $url_value;
	
	public $response;
	
	public $server_message;
	
	
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'ns_caisse_orders',
        'primary' => 'id_ns_caisse_orders',
        'multilang' => FALSE,
        'fields' => array(
            'id_order' => array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => TRUE),
			'id_shop' => array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => TRUE),
            'url_value' => array('type' => self::TYPE_HTML, 'validate' => 'isString'),
			'response' => array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => TRUE),
			'server_message' => array('type' => self::TYPE_HTML, 'validate' => 'isString'),
        ),
    );
	
    
	public static function loadByIdOrder($id_order){
        $result = Db::getInstance()->getRow('
            SELECT *
            FROM `'._DB_PREFIX_.'ns_caisse_orders` sample
            WHERE sample.`id_order` = '.(int)$id_order
        );
        
        return new ConfigHistory($result['id_ns_caisse_orders']);
    }
	
	
	
	public static function getHistories($id_shop)
	{
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

		$sql = 'SELECT *
			FROM `'._DB_PREFIX_.'ns_caisse_orders` sample
			WHERE sample.`id_shop` = '.(int)$id_shop.'
			';

		return Db::getInstance()->executeS($sql);
	}
	
	
	
	
	 public static function isOrderExist($id_order){
		 
		 $message=false;
		 
		  $result = Db::getInstance()->getRow('
            SELECT *
            FROM `'._DB_PREFIX_.'ns_caisse_orders` sample
            WHERE sample.`id_order` = '.(int)$id_order
        );
        
        $id_ns_caisse_orders=$result['id_ns_caisse_orders'];
		
		if(isset($id_ns_caisse_orders)  && $id_ns_caisse_orders>0){			
			$message=true;			
		}		
		
		return $message;
		
	 }
	 
	 
	 
	 /*
     * Generate correctly the address for an email  :  From ps_emailalert
     */
    public static function getFormatedAddress(Address $address, $line_sep, $fields_style = array())
    {
        return AddressFormat::generateAddress($address, array('avoid' => array()), $line_sep, ' ', $fields_style);
    }    
	
}

